const el = wp.element.createElement;

export default function getIcon( icon ) {
	if ( 'headline' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" className="gblocks-block-icon"><path style={ { fill: 'none' } } d="M0 0h24v24H0z" /><path d="M21.375 22h-5.769a.625.625 0 0 1-.625-.625v-6.042H9.019v6.042a.625.625 0 0 1-.625.625H2.625A.625.625 0 0 1 2 21.375V2.625C2 2.28 2.28 2 2.625 2h5.769c.346 0 .625.28.625.625v6.041h5.961V2.625A.626.626 0 0 1 15.606 2h5.769c.345 0 .625.28.625.625v18.75c0 .345-.28.625-.625.625zm-5.144-1.25h4.519V3.25h-4.519v6.041c0 .345-.28.625-.625.625H8.394a.625.625 0 0 1-.625-.625V3.25H3.25v17.5h4.519v-6.042c0-.345.28-.625.625-.625h7.212c.345 0 .625.28.625.625v6.042z" /></svg>;
	}

	if ( 'grid' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" className="gblocks-block-icon"><path style={ { fill: 'none' } } d="M0 0h24v24H0z" /><path d="M21.375 10.755h-4.689a.625.625 0 0 1-.625-.625V2.625c0-.345.28-.625.625-.625h4.689a.624.624 0 0 1 .625.625v7.505c0 .345-.28.625-.625.625zm-4.064-1.251h3.44V3.25h-3.44v6.254zm-4.474 1.251H2.625A.625.625 0 0 1 2 10.13V2.625C2 2.28 2.28 2 2.625 2h10.212c.345 0 .625.28.625.625v7.505a.626.626 0 0 1-.625.625zM3.249 9.504h8.963V3.25H3.249v6.254zm4.064 12.497H2.625A.625.625 0 0 1 2 21.375V13.87c0-.345.28-.625.625-.625h4.688c.345 0 .625.28.625.625v7.505a.627.627 0 0 1-.625.626zM3.249 20.75h3.439v-6.255H3.249v6.255zm18.126 1.251H11.162a.625.625 0 0 1-.625-.625V13.87c0-.345.28-.625.625-.625h10.213c.345 0 .625.28.625.625v7.505c0 .346-.28.626-.625.626zm-9.588-1.251h8.964v-6.255h-8.964v6.255z" /></svg>;
	}

	if ( 'container' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" className="gblocks-block-icon"><path style={ { fill: 'none' } } d="M0 0h24v24H0z" /><path d="M21.375 22h-3.75v-1.25h3.125v-3.125H22v3.75c0 .345-.28.625-.625.625zM9.188 20.75h5.625V22H9.188zM6.375 22h-3.75A.625.625 0 0 1 2 21.375v-3.75h1.25v3.125h3.125V22zM2 9.187h1.25v5.625H2zm1.25-2.812H2v-3.75C2 2.28 2.28 2 2.625 2h3.75v1.25H3.25v3.125zM9.188 2h5.625v1.25H9.188zM22 6.375h-1.25V3.25h-3.125V2h3.75c.345 0 .625.28.625.625v3.75zm-1.25 2.812H22v5.625h-1.25z" /></svg>;
	}

	if ( 'button' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" className="gblocks-block-icon"><path style={ { fill: 'none' } } d="M0 0h24v24H0z" /><path d="M21.375 16.45H2.625A.625.625 0 0 1 2 15.825v-7.65c0-.345.28-.625.625-.625h18.75c.345 0 .625.28.625.625v7.65c0 .345-.28.625-.625.625zM3.25 15.2h17.5V8.8H3.25v6.4z" /><path d="M15.536 12.625H5.882a.625.625 0 0 1 0-1.25h9.654a.625.625 0 0 1 0 1.25z" /><circle cx="17.936" cy="12" r=".807" /></svg>;
	}

	if ( 'button-container' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" className="gblocks-block-icon" width="24" height="24" aria-hidden="true" focusable="false">    <path d="M21.375,22L17.625,22L17.625,20.75L20.75,20.75L20.75,17.625L22,17.625L22,21.375C22,21.72 21.72,22 21.375,22ZM9.188,20.75L14.813,20.75L14.813,22L9.188,22L9.188,20.75ZM6.375,22L2.625,22C2.282,22 2,21.718 2,21.375L2,17.625L3.25,17.625L3.25,20.75L6.375,20.75L6.375,22ZM2,9.187L3.25,9.187L3.25,14.812L2,14.812L2,9.187ZM3.25,6.375L2,6.375L2,2.625C2,2.28 2.28,2 2.625,2L6.375,2L6.375,3.25L3.25,3.25L3.25,6.375ZM9.188,2L14.813,2L14.813,3.25L9.188,3.25L9.188,2ZM22,6.375L20.75,6.375L20.75,3.25L17.625,3.25L17.625,2L21.375,2C21.72,2 22,2.28 22,2.625L22,6.375ZM20.75,9.187L22,9.187L22,14.812L20.75,14.812L20.75,9.187Z" /><path d="M19.031,15.23L4.969,15.23C4.712,15.23 4.5,15.018 4.5,14.761L4.5,9.024C4.5,8.765 4.71,8.555 4.969,8.555L19.031,8.555C19.29,8.555 19.5,8.765 19.5,9.024L19.5,14.761C19.5,15.02 19.29,15.23 19.031,15.23ZM5.438,14.292L18.563,14.292L18.563,9.492L5.438,9.492L5.438,14.292Z" /><path d="M14.652,12.361L7.412,12.361C7.154,12.361 6.943,12.15 6.943,11.892C6.943,11.635 7.154,11.424 7.412,11.424L14.652,11.424C14.909,11.424 15.121,11.635 15.121,11.892C15.121,12.15 14.909,12.361 14.652,12.361Z" /><circle cx="16.452" cy="11.892" r="0.605" /></svg>;
	}

	if ( 'query-loop' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" className="gblocks-block-icon"><path style={ { fill: 'none' } } d="M0 0h24v24H0z" /><path d="M21.374 6.133H14.67a.625.625 0 0 1 0-1.25h6.704a.625.625 0 0 1 0 1.25zm0 2.882H14.67a.625.625 0 0 1 0-1.25h6.704a.625.625 0 0 1 0 1.25zm0-5.764H14.67a.625.625 0 0 1 0-1.251h6.704a.625.625 0 0 1 0 1.251zM9.329 19.118H2.625a.625.625 0 1 1 0-1.25h6.704a.625.625 0 0 1 0 1.25zm0 2.883H2.625a.625.625 0 0 1 0-1.25h6.704a.625.625 0 0 1 0 1.25zm0-5.766H2.625a.625.625 0 1 1 0-1.25h6.704a.625.625 0 0 1 0 1.25z" /><path d="M16.841 22.001a5.17 5.17 0 0 1-3.661-1.517c-1.961-1.961-1.876-5.29-1.793-8.51.095-3.705.185-7.204-2.646-8.399-1.275-.538-2.731-.405-3.8.351-.981.692-1.576 1.721-1.677 2.895a3.929 3.929 0 0 0 1.137 3.116c.882.882 2.245 1.322 4.419 1.428.344.017.61.31.594.655a.621.621 0 0 1-.655.594c-1.688-.082-3.81-.36-5.242-1.792a5.179 5.179 0 0 1-1.498-4.107A5.211 5.211 0 0 1 4.22 2.904c1.418-1.002 3.337-1.186 5.006-.481 3.616 1.526 3.511 5.622 3.409 9.583-.076 2.956-.154 6.012 1.428 7.594a3.924 3.924 0 0 0 3.114 1.137c1.174-.1 2.202-.695 2.896-1.675.754-1.066.889-2.52.353-3.796-.72-1.716-2.283-2.509-5.226-2.652a.626.626 0 0 1-.594-.655.615.615 0 0 1 .655-.594c2.32.112 5.136.602 6.317 3.416.701 1.67.515 3.587-.486 5.002a5.204 5.204 0 0 1-4.251 2.218z" /></svg>;
	}

	if ( 'image' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" className="gblocks-block-icon"><path style={ { fill: 'none' } } d="M0 0h24v24H0z" /><path d="M15.77 11.655a3.429 3.429 0 0 1-3.425-3.425 3.428 3.428 0 0 1 3.425-3.425 3.429 3.429 0 0 1 3.424 3.425 3.429 3.429 0 0 1-3.424 3.425zm0-5.6a2.179 2.179 0 0 0-2.176 2.175c0 1.199.977 2.175 2.176 2.175s2.175-.976 2.175-2.175a2.178 2.178 0 0 0-2.175-2.175z" /><path d="M21.375 22.001H2.625A.625.625 0 0 1 2 21.375V2.625C2 2.28 2.28 2 2.625 2h18.751a.624.624 0 0 1 .624.625v18.751c0 .345-.28.625-.625.625zM3.249 20.75H20.75V3.25H3.249v17.5z" /><path d="M20.956 21.839 8.968 11.018l-5.91 5.698-.867-.9L8.52 9.714a.624.624 0 0 1 .853-.014l12.422 11.212-.839.927z" /></svg>;
	}

	if ( 'text' === icon ) {
		return (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" className="gblocks-block-icon" aria-hidden="true" focusable="false">
				<path d="M8.666,21.375L8.667,9.019L2.625,9.019C2.282,9.019 2,8.737 2,8.394L2,2.625C2,2.282 2.282,2 2.625,2L21.375,2C21.72,2 22,2.28 22,2.625L22,8.394C22,8.74 21.72,9.019 21.375,9.019L15.334,9.019L15.348,21.375C15.348,21.72 15.068,22 14.723,22L9.291,22C8.946,22 8.666,21.72 8.666,21.375ZM9.917,8.394L9.916,20.75L14.098,20.75L14.084,8.394C14.084,8.051 14.366,7.769 14.709,7.769L20.75,7.769L20.75,3.25L3.25,3.25L3.25,7.769L9.292,7.769C9.637,7.769 9.917,8.049 9.917,8.394Z" />
			</svg>
		);
	}

	if ( 'shape' === icon ) {
		return (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" className="gblocks-block-icon" aria-hidden="true" focusable="false">
				<path d="M22,11.5L12.5,11.5L12.5,2L22,2L22,11.5ZM13.75,3.25L13.75,10.25L20.75,10.25L20.75,3.25L13.75,3.25Z" />
				<path d="M6.811,12.5L6.873,12.502L6.933,12.503L6.994,12.506L7.055,12.51L7.115,12.514L7.175,12.519L7.235,12.525L7.295,12.531L7.355,12.538L7.414,12.546L7.473,12.555L7.59,12.574L7.707,12.597L7.822,12.622L7.937,12.65L8.05,12.68L8.162,12.714L8.273,12.75L8.383,12.788L8.491,12.83L8.598,12.874L8.704,12.92L8.809,12.969L8.912,13.02L9.013,13.074L9.114,13.13L9.212,13.188L9.309,13.249L9.405,13.312L9.499,13.377L9.591,13.444L9.682,13.514L9.771,13.585L9.858,13.659L9.943,13.735L10.027,13.812L10.108,13.892L10.188,13.973L10.265,14.057L10.341,14.142L10.415,14.229L10.486,14.318L10.556,14.409L10.623,14.501L10.688,14.595L10.751,14.691L10.812,14.788L10.87,14.886L10.926,14.987L10.98,15.088L11.031,15.191L11.08,15.296L11.126,15.402L11.17,15.509L11.212,15.617L11.25,15.727L11.286,15.838L11.32,15.95L11.35,16.063L11.378,16.178L11.403,16.293L11.426,16.41L11.445,16.527L11.454,16.586L11.462,16.645L11.469,16.705L11.475,16.765L11.481,16.825L11.486,16.885L11.49,16.945L11.494,17.006L11.497,17.067L11.498,17.127L11.5,17.189L11.5,17.25L11.5,17.311L11.498,17.373L11.497,17.433L11.494,17.494L11.49,17.555L11.486,17.615L11.481,17.675L11.475,17.735L11.469,17.795L11.462,17.855L11.454,17.914L11.445,17.973L11.426,18.09L11.403,18.207L11.378,18.322L11.35,18.437L11.32,18.55L11.286,18.662L11.25,18.773L11.212,18.883L11.17,18.991L11.126,19.098L11.08,19.204L11.031,19.309L10.98,19.412L10.926,19.513L10.87,19.614L10.812,19.712L10.751,19.809L10.688,19.905L10.623,19.999L10.556,20.091L10.486,20.182L10.415,20.271L10.341,20.358L10.265,20.443L10.188,20.527L10.108,20.608L10.027,20.688L9.943,20.765L9.858,20.841L9.771,20.915L9.682,20.986L9.591,21.056L9.499,21.123L9.405,21.188L9.309,21.251L9.212,21.312L9.114,21.37L9.013,21.426L8.912,21.48L8.809,21.531L8.704,21.58L8.598,21.626L8.491,21.67L8.383,21.712L8.273,21.75L8.162,21.786L8.05,21.82L7.937,21.85L7.822,21.878L7.707,21.903L7.59,21.926L7.473,21.945L7.414,21.954L7.355,21.962L7.295,21.969L7.235,21.975L7.175,21.981L7.115,21.986L7.055,21.99L6.994,21.994L6.933,21.997L6.873,21.998L6.811,22L6.75,22L6.689,22L6.627,21.998L6.567,21.997L6.506,21.994L6.445,21.99L6.385,21.986L6.325,21.981L6.265,21.975L6.205,21.969L6.145,21.962L6.086,21.954L6.027,21.945L5.91,21.926L5.793,21.903L5.678,21.878L5.563,21.85L5.45,21.82L5.338,21.786L5.227,21.75L5.117,21.712L5.009,21.67L4.902,21.626L4.796,21.58L4.691,21.531L4.588,21.48L4.487,21.426L4.386,21.37L4.288,21.312L4.191,21.251L4.095,21.188L4.001,21.123L3.909,21.056L3.818,20.986L3.729,20.915L3.642,20.841L3.557,20.765L3.473,20.688L3.392,20.608L3.312,20.527L3.235,20.443L3.159,20.358L3.085,20.271L3.014,20.182L2.944,20.091L2.877,19.999L2.812,19.905L2.749,19.809L2.688,19.712L2.63,19.614L2.574,19.513L2.52,19.412L2.469,19.309L2.42,19.204L2.374,19.098L2.33,18.991L2.288,18.883L2.25,18.773L2.214,18.662L2.18,18.55L2.15,18.437L2.122,18.322L2.097,18.207L2.074,18.09L2.055,17.973L2.046,17.914L2.038,17.855L2.031,17.795L2.025,17.735L2.019,17.675L2.014,17.615L2.01,17.555L2.006,17.494L2.003,17.433L2.002,17.373L2,17.311L2,17.25L2,17.189L2.002,17.127L2.003,17.067L2.006,17.006L2.01,16.945L2.014,16.885L2.019,16.825L2.025,16.765L2.031,16.705L2.038,16.645L2.046,16.586L2.055,16.527L2.074,16.41L2.097,16.293L2.122,16.178L2.15,16.063L2.18,15.95L2.214,15.838L2.25,15.727L2.288,15.617L2.33,15.509L2.374,15.402L2.42,15.296L2.469,15.191L2.52,15.088L2.574,14.987L2.63,14.886L2.688,14.788L2.749,14.691L2.812,14.595L2.877,14.501L2.944,14.409L3.014,14.318L3.085,14.229L3.159,14.142L3.235,14.057L3.312,13.973L3.392,13.892L3.473,13.812L3.557,13.735L3.642,13.659L3.729,13.585L3.818,13.514L3.909,13.444L4.001,13.377L4.095,13.312L4.191,13.249L4.288,13.188L4.386,13.13L4.487,13.074L4.588,13.02L4.691,12.969L4.796,12.92L4.902,12.874L5.009,12.83L5.117,12.788L5.227,12.75L5.338,12.714L5.45,12.68L5.563,12.65L5.678,12.622L5.793,12.597L5.91,12.574L6.027,12.555L6.086,12.546L6.145,12.538L6.205,12.531L6.265,12.525L6.325,12.519L6.385,12.514L6.445,12.51L6.506,12.506L6.567,12.503L6.627,12.502L6.689,12.5L6.75,12.5L6.811,12.5ZM6.66,13.751L6.57,13.755L6.481,13.76L6.392,13.768L6.304,13.778L6.217,13.79L6.131,13.805L6.045,13.821L5.96,13.84L5.876,13.86L5.792,13.883L5.71,13.907L5.628,13.934L5.547,13.963L5.467,13.993L5.388,14.025L5.31,14.059L5.233,14.095L5.157,14.133L5.082,14.173L5.008,14.214L4.936,14.257L4.864,14.302L4.794,14.348L4.724,14.396L4.656,14.446L4.59,14.497L4.524,14.55L4.46,14.604L4.397,14.66L4.336,14.717L4.276,14.776L4.217,14.836L4.16,14.897L4.104,14.96L4.05,15.024L3.997,15.09L3.946,15.156L3.896,15.224L3.848,15.294L3.802,15.364L3.757,15.436L3.714,15.508L3.673,15.582L3.633,15.657L3.595,15.733L3.559,15.81L3.525,15.888L3.493,15.967L3.463,16.047L3.434,16.128L3.407,16.21L3.383,16.292L3.36,16.376L3.34,16.46L3.321,16.545L3.305,16.631L3.29,16.717L3.278,16.804L3.268,16.892L3.26,16.981L3.255,17.07L3.251,17.16L3.25,17.25L3.251,17.34L3.255,17.43L3.26,17.519L3.268,17.608L3.278,17.696L3.29,17.783L3.305,17.869L3.321,17.955L3.34,18.04L3.36,18.124L3.383,18.208L3.407,18.29L3.434,18.372L3.463,18.453L3.493,18.533L3.525,18.612L3.559,18.69L3.595,18.767L3.633,18.843L3.673,18.918L3.714,18.992L3.757,19.064L3.802,19.136L3.848,19.206L3.896,19.276L3.946,19.344L3.997,19.41L4.05,19.476L4.104,19.54L4.16,19.603L4.217,19.664L4.276,19.724L4.336,19.783L4.397,19.84L4.46,19.896L4.524,19.95L4.59,20.003L4.656,20.054L4.724,20.104L4.794,20.152L4.864,20.198L4.936,20.243L5.008,20.286L5.082,20.327L5.157,20.367L5.233,20.405L5.31,20.441L5.388,20.475L5.467,20.507L5.547,20.537L5.628,20.566L5.71,20.593L5.792,20.617L5.876,20.64L5.96,20.66L6.045,20.679L6.131,20.695L6.217,20.71L6.304,20.722L6.392,20.732L6.481,20.74L6.57,20.745L6.66,20.749L6.75,20.75L6.84,20.749L6.93,20.745L7.019,20.74L7.108,20.732L7.196,20.722L7.283,20.71L7.369,20.695L7.455,20.679L7.54,20.66L7.624,20.64L7.708,20.617L7.79,20.593L7.872,20.566L7.953,20.537L8.033,20.507L8.112,20.475L8.19,20.441L8.267,20.405L8.343,20.367L8.418,20.327L8.492,20.286L8.564,20.243L8.636,20.198L8.706,20.152L8.776,20.104L8.844,20.054L8.91,20.003L8.976,19.95L9.04,19.896L9.103,19.84L9.164,19.783L9.224,19.724L9.283,19.664L9.34,19.603L9.396,19.54L9.45,19.476L9.503,19.41L9.554,19.344L9.604,19.276L9.652,19.206L9.698,19.136L9.743,19.064L9.786,18.992L9.827,18.918L9.867,18.843L9.905,18.767L9.941,18.69L9.975,18.612L10.007,18.533L10.037,18.453L10.066,18.372L10.093,18.29L10.117,18.208L10.14,18.124L10.16,18.04L10.179,17.955L10.195,17.869L10.21,17.783L10.222,17.696L10.232,17.608L10.24,17.519L10.245,17.43L10.249,17.34L10.25,17.25L10.249,17.16L10.245,17.07L10.24,16.981L10.232,16.892L10.222,16.804L10.21,16.717L10.195,16.631L10.179,16.545L10.16,16.46L10.14,16.376L10.117,16.292L10.093,16.21L10.066,16.128L10.037,16.047L10.007,15.967L9.975,15.888L9.941,15.81L9.905,15.733L9.867,15.657L9.827,15.582L9.786,15.508L9.743,15.436L9.698,15.364L9.652,15.294L9.604,15.224L9.554,15.156L9.503,15.09L9.45,15.024L9.396,14.96L9.34,14.897L9.283,14.836L9.224,14.776L9.164,14.717L9.103,14.66L9.04,14.604L8.976,14.55L8.91,14.497L8.844,14.446L8.776,14.396L8.706,14.348L8.636,14.302L8.564,14.257L8.492,14.214L8.418,14.173L8.343,14.133L8.267,14.095L8.19,14.059L8.112,14.025L8.033,13.993L7.953,13.963L7.872,13.934L7.79,13.907L7.708,13.883L7.624,13.86L7.54,13.84L7.455,13.821L7.369,13.805L7.283,13.79L7.196,13.778L7.108,13.768L7.019,13.76L6.93,13.755L6.84,13.751L6.75,13.75L6.66,13.751Z" />
				<path d="M11.5,11.5L2,11.5L6.75,2C8.333,5.167 9.917,8.333 11.5,11.5ZM4.023,10.25L9.477,10.25L6.75,4.795C5.841,6.613 4.932,8.432 4.023,10.25Z" />
				<path d="M22,14.875L19.625,17.25L22,19.625L19.625,22L17.25,19.625L14.875,22L12.5,19.625L14.875,17.25L12.5,14.875L14.875,12.5L17.25,14.875L19.625,12.5C20.417,13.292 21.208,14.083 22,14.875ZM18.134,15.759C17.647,16.22 16.86,16.226 16.366,15.759L14.875,14.268L14.268,14.875L15.759,16.366C16.22,16.853 16.226,17.64 15.759,18.134L14.268,19.625L14.875,20.232L16.366,18.741C16.855,18.278 17.645,18.278 18.134,18.741L19.625,20.232L20.232,19.625L18.741,18.134C18.28,17.647 18.274,16.86 18.741,16.366L20.232,14.875L19.625,14.268C19.128,14.765 18.631,15.262 18.134,15.759Z" />
			</svg>
		);
	}

	if ( 'spacing' === icon ) {
		return el( 'svg', { width: 20, height: 20, viewBox: '0 0 113 113', fillRule: 'evenodd' },
			el( 'path', {
				d: 'M106.283,6.217c8.289,8.29 8.289,91.776 0,100.066c-8.29,8.289 -91.776,8.289 -100.066,0c-8.289,-8.29 -8.289,-91.776 0,-100.066c8.29,-8.289 91.776,-8.289 100.066,0Zm-10.007,10.007c6.632,6.632 6.632,73.42 0,80.052c-6.632,6.632 -73.42,6.632 -80.052,0c-6.632,-6.632 -6.632,-73.42 0,-80.052c6.632,-6.632 73.42,-6.632 80.052,0Z',
			} ),
			el( 'path', {
				d: 'M40.452,77.705c7.802,1.393 23.794,1.393 31.596,0l13.635,13.635c-12.215,3.213 -46.652,3.213 -58.866,0l13.635,-13.635Zm50.888,-50.888c3.213,12.215 3.213,46.653 0,58.866l-13.635,-13.635c1.393,-7.801 1.393,-23.794 0,-31.596l13.635,-13.635Zm-70.18,0l13.635,13.635c-1.393,7.802 -1.393,23.794 0,31.596l-13.635,13.635c-3.213,-12.213 -3.213,-46.651 0,-58.866Zm5.657,-5.657c12.214,-3.213 46.652,-3.213 58.866,0l-13.635,13.635c-7.801,-1.393 -23.795,-1.393 -31.596,0l-13.635,-13.635Z',
			} ),
		);
	}

	if ( 'backgrounds' === icon ) {
		return el( 'svg', { width: 20, height: 20, viewBox: '0 0 113 113', fillRule: 'evenodd' },
			el( 'path', {
				d: 'M1.491,87.777l37.79,-37.79l31.352,31.352c2.412,2.171 5.656,0 5.656,0l17.248,-17.247l13.186,13.186l4.796,4.797c-0.971,12.199 -2.726,21.685 -5.249,24.208c-8.29,8.289 -91.776,8.289 -100.066,0c-2.113,-2.113 -3.687,-9.113 -4.713,-18.506Z',
			} ),
			el( 'path', {
				d: 'M0.631,77.323c-1.742,-27.728 0.125,-65.658 5.573,-71.106c8.29,-8.289 91.776,-8.289 100.066,0c5.07,5.07 7.039,38.265 5.89,65.185l-15.795,-15.795c-2.412,-2.172 -5.657,0 -5.657,0l-17.247,17.246l-31.351,-31.351c-0.731,-0.658 -1.036,-1 -2.619,-1.166c-0.263,0 -0.477,-0.075 -1.245,0.131c-0.912,0.244 -1.793,1.035 -1.793,1.035l-35.822,35.821Zm76.434,-59.584c7.115,0 12.891,5.776 12.891,12.89c0,7.114 -5.776,12.89 -12.891,12.89c-7.114,0 -12.89,-5.776 -12.89,-12.89c0,-7.114 5.776,-12.89 12.89,-12.89Z',
			} ),
		);
	}

	if ( 'colors' === icon ) {
		return el( 'svg', { width: 20, height: 20, viewBox: '0 0 113 113', fillRule: 'evenodd' },
			el( 'path', {
				d: 'M106.283,6.217c8.289,8.29 8.289,91.776 0,100.066c-8.29,8.289 -91.776,8.289 -100.066,0c-8.289,-8.29 -8.289,-91.776 0,-100.066c8.29,-8.289 91.776,-8.289 100.066,0Zm-50.033,12.818c-20.551,0 -37.215,16.664 -37.215,37.215c0,20.551 16.664,37.215 37.215,37.215c3.432,0 6.202,-2.77 6.202,-6.203c0,-1.612 -0.62,-3.059 -1.612,-4.176c-0.951,-1.075 -1.571,-2.522 -1.571,-4.094c0,-3.432 2.77,-6.202 6.202,-6.202l7.319,0c11.413,0 20.675,-9.262 20.675,-20.675c0,-18.277 -16.664,-33.08 -37.215,-33.08Zm-22.742,37.215c-3.433,0 -6.203,-2.77 -6.203,-6.202c0,-3.433 2.77,-6.203 6.203,-6.203c3.432,0 6.202,2.77 6.202,6.203c0,3.432 -2.77,6.202 -6.202,6.202Zm45.484,0c-3.432,0 -6.202,-2.77 -6.202,-6.202c0,-3.433 2.77,-6.203 6.202,-6.203c3.433,0 6.203,2.77 6.203,6.203c0,3.432 -2.77,6.202 -6.203,6.202Zm-33.079,-16.54c-3.433,0 -6.203,-2.77 -6.203,-6.202c0,-3.433 2.77,-6.203 6.203,-6.203c3.432,0 6.202,2.77 6.202,6.203c0,3.432 -2.77,6.202 -6.202,6.202Zm20.674,0c-3.432,0 -6.202,-2.77 -6.202,-6.202c0,-3.433 2.77,-6.203 6.202,-6.203c3.433,0 6.203,2.77 6.203,6.203c0,3.432 -2.77,6.202 -6.203,6.202Z',
			} ),
		);
	}

	if ( 'gradients' === icon ) {
		return el( 'svg', { width: 20, height: 20, viewBox: '0 0 113 113', fillRule: 'evenodd' },
			el( 'path', {
				d: 'M112.426,48.746c0.503,25.204 -1.545,52.939 -6.143,57.537c-8.29,8.289 -91.776,8.289 -100.066,0c-8.289,-8.29 -8.289,-91.776 0,-100.066c8.289,-8.288 91.748,-8.289 100.061,-0.004c0,0 0.005,0.004 0.005,0.004c3.691,3.692 5.739,22.295 6.143,42.529Zm-16.154,-32.526c-6.656,-6.628 -73.418,-6.627 -80.048,0.004c-6.631,6.63 -6.632,73.392 -0.004,80.048l80.052,-80.052Z',
			} ),
		);
	}

	if ( 'icons' === icon ) {
		return el( 'svg', { width: 20, height: 20, viewBox: '0 0 113 113', fillRule: 'evenodd' },
			el( 'path', {
				d: 'M106.283,6.217c8.289,8.29 8.289,91.776 0,100.066c-8.29,8.289 -91.776,8.289 -100.066,0c-8.289,-8.29 -8.289,-91.776 0,-100.066c8.29,-8.289 91.776,-8.289 100.066,0Zm-10.007,10.007c6.632,6.632 6.632,73.42 0,80.052c-6.632,6.632 -73.42,6.632 -80.052,0c-6.632,-6.632 -6.632,-73.42 0,-80.052c6.632,-6.632 73.42,-6.632 80.052,0Z',
			} ),
			el( 'path', {
				d: 'M89.605,22.895c5.527,5.526 5.527,61.184 0,66.71c-5.526,5.527 -61.184,5.527 -66.71,0c-5.527,-5.526 -5.527,-61.184 0,-66.71c5.526,-5.527 61.184,-5.527 66.71,0Zm-21.066,62.31l0,-2.731c-0.648,-0.074 -1.272,-0.199 -1.87,-0.374c-0.599,-0.174 -1.148,-0.374 -1.646,-0.598c-0.699,-0.299 -1.235,-0.755 -1.609,-1.366c-0.374,-0.611 -0.561,-1.353 -0.561,-2.226l0,-29.703l-0.561,-0.561l-18.331,0.972l0,2.731c0.748,0.075 1.577,0.25 2.488,0.524c0.91,0.274 1.589,0.561 2.038,0.86c0.599,0.399 1.098,0.929 1.497,1.59c0.399,0.661 0.598,1.428 0.598,2.301l0,21.773c0,0.923 -0.162,1.665 -0.486,2.226c-0.324,0.561 -0.885,0.991 -1.683,1.29c-0.449,0.175 -0.986,0.3 -1.609,0.374c-0.624,0.075 -1.26,0.138 -1.908,0.187l0,2.731l23.643,0Zm-12.978,-59.459c4.76,0 8.625,3.864 8.625,8.625c0,4.76 -3.865,8.625 -8.625,8.625c-4.76,0 -8.625,-3.865 -8.625,-8.625c0,-4.761 3.865,-8.625 8.625,-8.625Z',
			} ),
		);
	}

	if ( 'typography' === icon ) {
		return el( 'svg', { width: 20, height: 20, viewBox: '0 0 113 113', fillRule: 'evenodd' },
			el( 'path', {
				d: 'M106.283,6.217c8.289,8.29 8.289,91.776 0,100.066c-8.29,8.289 -91.776,8.289 -100.066,0c-8.289,-8.29 -8.289,-91.776 0,-100.066c8.29,-8.289 91.776,-8.289 100.066,0Zm-8.783,78.583l0,-2.817c-0.661,-0.026 -1.481,-0.165 -2.46,-0.417c-0.979,-0.251 -1.773,-0.562 -2.381,-0.932c-0.9,-0.609 -1.601,-1.23 -2.103,-1.865c-0.503,-0.635 -0.953,-1.468 -1.349,-2.5l-18.769,-48.569l-3.175,0c-2.672,6.878 -5.714,14.721 -9.126,23.53c-3.266,8.43 -6.265,16.06 -8.998,22.891l-11.672,-28.684l-2.304,0c-1.939,4.742 -4.148,10.149 -6.625,16.222c-2.477,6.072 -4.743,11.543 -6.798,16.412c-0.403,0.949 -0.816,1.692 -1.238,2.23c-0.423,0.538 -1.018,1.053 -1.786,1.545c-0.48,0.292 -1.095,0.524 -1.844,0.698c-0.749,0.173 -1.373,0.278 -1.872,0.314l0,1.942l15.382,0l0,-1.942c-1.518,-0.073 -2.881,-0.31 -4.091,-0.711c-1.209,-0.401 -1.814,-0.966 -1.814,-1.696c0,-0.31 0.048,-0.711 0.144,-1.204c0.096,-0.492 0.268,-1.13 0.518,-1.914c0.269,-0.803 0.571,-1.678 0.907,-2.626c0.336,-0.948 0.773,-2.061 1.311,-3.338l14.316,0l3.399,8.699c0.012,0.03 0.024,0.06 0.036,0.092c-0.161,0.119 -0.329,0.237 -0.503,0.355c-0.661,0.423 -1.508,0.76 -2.539,1.012c-1.032,0.251 -1.892,0.403 -2.58,0.456l0,2.817l21.19,0l0,-2.817c-2.09,-0.106 -3.968,-0.45 -5.635,-1.032c-1.666,-0.582 -2.499,-1.402 -2.499,-2.46c0,-0.45 0.066,-1.032 0.198,-1.746c0.132,-0.714 0.37,-1.64 0.714,-2.777c0.371,-1.164 0.787,-2.434 1.25,-3.81c0.463,-1.375 1.065,-2.989 1.806,-4.841l19.721,0l4.682,12.619c0.106,0.264 0.186,0.568 0.238,0.912c0.053,0.344 0.08,0.635 0.08,0.873c0,0.582 -0.681,1.072 -2.044,1.468c-1.362,0.397 -3.075,0.662 -5.138,0.794l0,2.817l23.451,0Zm-56.864,-15.865l-6.193,-15.045l-6.078,15.045l12.271,0Zm34.167,-7.15l-8.532,-21.824l-8.373,21.824l16.905,0Z',
			} ),
		);
	}

	if ( 'addContainer' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path style={ { fill: 'none' } } d="M0 0h24v24H0z" /><path d="M21.375 22h-3.75v-1.25h3.125v-3.125H22v3.75c0 .345-.28.625-.625.625zM9.188 20.75h5.625V22H9.188zM6.375 22h-3.75A.625.625 0 0 1 2 21.375v-3.75h1.25v3.125h3.125V22zM2 9.187h1.25v5.625H2zm1.25-2.812H2v-3.75C2 2.28 2.28 2 2.625 2h3.75v1.25H3.25v3.125zM9.188 2h5.625v1.25H9.188zM22 6.375h-1.25V3.25h-3.125V2h3.75c.345 0 .625.28.625.625v3.75zm-1.25 2.812H22v5.625h-1.25zM12 18.293a.625.625 0 0 1-.625-.625V6.331a.625.625 0 0 1 1.25 0v11.337c0 .346-.28.625-.625.625z" /><path d="M17.669 12.625H6.332a.625.625 0 0 1 0-1.25h11.337a.625.625 0 0 1 0 1.25z" /></svg>;
	}

	if ( 'documentation' === icon ) {
		return el( 'svg', { width: 20, height: 20, viewBox: '0 0 113 113', fillRule: 'evenodd' },
			el( 'path', {
				d: 'M106.755 6.245c8.327 8.326 8.327 92.184 0 100.51-8.326 8.327-92.184 8.327-100.51 0-8.327-8.326-8.327-92.184 0-100.51 8.326-8.327 92.184-8.327 100.51 0zm-92.661 93.896C9.279 84 9.781 23.714 15.834 17.661c2.491-2.491 19.588-4.132 26.354-4.712 4.748-.408 10.115.671 14.243 1.23 4.128-.559 9.495-1.638 14.243-1.23 6.766.58 23.863 2.221 26.354 4.712 6.053 6.053 6.791 66.339 1.976 82.48-4.729-1.977-19.708-3.436-26.784-3.853-5.234-.308-11.129.739-15.671 1.354-4.543-.615-10.437-1.662-15.672-1.354-7.075.417-22.054 1.876-26.783 3.853z',
			} ),
			el( 'path', {
				d: 'M50.188 32.738c2.252.536 2.252 5.927 0 6.463-2.252.535-24.934.535-27.186 0-2.252-.536-2.252-5.927 0-6.463 2.252-.535 24.934-.535 27.186 0zM50.277 46.846c2.252.535 2.252 5.927 0 6.462-2.252.535-24.934.535-27.186 0-2.252-.535-2.252-5.927 0-6.462 2.252-.535 24.934-.535 27.186 0zM50.277 60.037c2.252.535 2.252 5.927 0 6.462-2.252.535-24.934.535-27.186 0-2.252-.535-2.252-5.927 0-6.462 2.252-.535 24.934-.535 27.186 0zM50.277 73.799c2.252.536 2.252 5.927 0 6.463-2.252.535-24.934.535-27.186 0-2.252-.536-2.252-5.927 0-6.463 2.252-.535 24.934-.535 27.186 0z',
			} ),
			el( 'path', {
				d: 'M89.909 32.738c2.252.536 2.252 5.927 0 6.463-2.252.535-24.934.535-27.186 0-2.252-.536-2.252-5.927 0-6.463 2.252-.535 24.934-.535 27.186 0zM89.998 46.846c2.252.535 2.252 5.927 0 6.462-2.252.535-24.934.535-27.186 0-2.252-.535-2.252-5.927 0-6.462 2.252-.535 24.934-.535 27.186 0zM89.998 60.037c2.252.535 2.252 5.927 0 6.462-2.252.535-24.934.535-27.186 0-2.252-.535-2.252-5.927 0-6.462 2.252-.535 24.934-.535 27.186 0z',
			} ),
		);
	}

	if ( 'layout' === icon ) {
		return el( 'svg', { width: 20, height: 20, viewBox: '0 0 113 113', fillRule: 'evenodd' },
			el( 'path', {
				d: 'M106.719 6.238c8.362 8.362 8.362 92.208 0 100.57-8.362 8.287-92.208 8.287-100.495 0-8.362-8.362-8.362-92.208 0-100.57 8.287-8.286 92.133-8.286 100.495 0zm-9.417 9.417c6.78 6.78 6.78 74.957 0 81.737-6.78 6.78-74.956 6.78-81.661 0-6.78-6.78-6.78-74.957 0-81.737 6.705-6.78 74.881-6.78 81.661 0z',
			} ),
			el( 'path', {
				d: 'M93.988 48.877c.602 17.477-.754 37.893-3.993 41.132-3.164 3.164-22.75 4.52-40.002 4.068v-45.2h43.995zm-75.108 0h23.58v44.899c-9.718-.603-17.553-1.808-19.512-3.767-3.24-3.24-4.595-23.655-4.068-41.132zm.377-7.533c.678-9.19 1.883-16.498 3.691-18.306 5.575-5.575 61.472-5.575 67.047 0 1.808 1.808 3.013 9.115 3.691 18.306h-74.43z',
			} ),
		);
	}

	if ( 'shapes' === icon ) {
		return el( 'svg', { width: 20, height: 20, viewBox: '0 0 113 113', fillRule: 'evenodd' },
			el( 'path', {
				d: 'M106.756,6.244C115.081,14.571 115.081,98.429 106.756,106.756C98.429,115.081 14.571,115.081 6.244,106.756C-2.081,98.429 -2.081,14.571 6.244,6.244C14.571,-2.081 98.429,-2.081 106.756,6.244ZM67.875,88.052C67.875,86.977 67.003,86.105 65.928,86.105L47.072,86.105C45.997,86.105 45.125,86.977 45.125,88.052L45.125,91.948C45.125,93.023 45.997,93.896 47.072,93.896L65.928,93.896C67.003,93.896 67.875,93.023 67.875,91.948L67.875,88.052ZM57.899,31.409L59.305,31.409C60.853,31.409 62.11,30.152 62.11,28.604L62.11,28.089L73.263,57.543C73.757,58.333 73.731,59.161 73.731,59.403C73.729,62.659 65.231,69.414 65.375,83.611L47.625,83.611C47.769,69.414 39.271,62.659 39.269,59.403C39.269,59.161 39.243,58.333 39.737,57.543L50.89,28.089L50.89,28.604C50.89,30.152 52.147,31.409 53.695,31.409L55.101,31.409C55.111,35.738 55.142,50.367 55.098,54.109C55.093,54.494 54.907,54.988 54.68,55.45C52.915,56.169 51.669,57.903 51.669,59.925C51.669,62.592 53.834,64.756 56.5,64.756C59.166,64.756 61.331,62.592 61.331,59.925C61.331,57.903 60.085,56.169 58.32,55.45C58.093,54.988 57.907,54.494 57.902,54.109C57.858,50.367 57.889,35.738 57.899,31.409ZM52.227,19.451L52.227,18.881C52.227,17.702 53.185,16.745 54.364,16.745L58.636,16.745C59.815,16.745 60.773,17.702 60.773,18.881L60.773,19.451L88.831,19.451C89.457,17.867 91.002,16.745 92.807,16.745C95.165,16.745 97.08,18.66 97.08,21.018C97.08,23.376 95.165,25.29 92.807,25.29C91.03,25.29 89.505,24.203 88.861,22.658L71.798,22.658C83.83,28.003 92.531,39.501 93.898,53.148L94.93,53.148C96.109,53.148 97.067,54.105 97.067,55.284L97.067,59.557C97.067,60.736 96.109,61.693 94.93,61.693L90.657,61.693C89.478,61.693 88.521,60.736 88.521,59.557L88.521,55.284C88.521,54.105 89.478,53.148 90.657,53.148L90.922,53.148C89.19,37.24 76.627,24.564 60.773,22.659L60.773,23.154C60.773,24.333 59.815,25.29 58.636,25.29L54.364,25.29C53.185,25.29 52.227,24.333 52.227,23.154L52.227,22.688C36.484,24.689 24.036,37.318 22.312,53.148L22.329,53.148C23.508,53.148 24.466,54.105 24.466,55.284L24.466,59.557C24.466,60.736 23.508,61.693 22.329,61.693L18.056,61.693C16.877,61.693 15.92,60.736 15.92,59.557L15.92,55.284C15.92,54.105 16.877,53.148 18.056,53.148L19.336,53.148C20.703,39.501 29.405,28.003 41.437,22.658L24.139,22.658C23.495,24.203 21.97,25.29 20.193,25.29C17.835,25.29 15.92,23.376 15.92,21.018C15.92,18.66 17.835,16.745 20.193,16.745C21.998,16.745 23.543,17.867 24.169,19.451L52.227,19.451Z',
			} ),
		);
	}

	if ( 'sizing' === icon ) {
		return <svg width="20" height="20" viewBox="0 0 113 113" style={ { fillRule: 'evenodd' } }><path d="M106.283,6.217C114.572,14.507 114.572,97.993 106.283,106.283C97.993,114.572 14.507,114.572 6.217,106.283C-2.072,97.993 -2.072,14.507 6.217,6.217C14.507,-2.072 97.993,-2.072 106.283,6.217ZM96.276,16.224C102.908,22.856 102.908,89.644 96.276,96.276C89.644,102.908 22.856,102.908 16.224,96.276C9.592,89.644 9.592,22.856 16.224,16.224C22.856,9.592 89.644,9.592 96.276,16.224Z" /><path d="M61.111,66.666L61.111,82.793C68.473,82.75 74.913,82.604 76.176,82.357C67.724,90.476 59.273,97.249 56.25,97.249C53.227,97.249 44.775,90.476 36.324,82.357C37.586,82.604 44.027,82.75 51.388,82.793L51.388,66.666L61.111,66.666ZM66.666,51.388L82.793,51.388C82.75,44.027 82.604,37.586 82.357,36.324C90.476,44.775 97.249,53.227 97.249,56.25C97.249,59.273 90.476,67.724 82.357,76.176C82.604,74.913 82.75,68.473 82.793,61.111L66.666,61.111L66.666,51.388ZM45.834,51.388L45.834,61.111L29.706,61.111C29.75,68.473 29.895,74.913 30.143,76.176C22.024,67.724 15.25,59.273 15.25,56.25C15.25,53.227 22.024,44.775 30.143,36.324C29.896,37.586 29.75,44.027 29.706,51.388L45.834,51.388ZM51.388,45.834L51.388,29.706C44.027,29.75 37.586,29.895 36.324,30.143C44.775,22.024 53.227,15.25 56.25,15.25C59.273,15.25 67.724,22.024 76.176,30.143C74.913,29.896 68.473,29.75 61.111,29.706L61.111,45.834L51.388,45.834Z" /></svg>;
	}

	if ( 'wrench' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><rect x="0" fill="none" width="20" height="20" /><g><path d="M16.68 9.77c-1.34 1.34-3.3 1.67-4.95.99l-5.41 6.52c-.99.99-2.59.99-3.58 0s-.99-2.59 0-3.57l6.52-5.42c-.68-1.65-.35-3.61.99-4.95 1.28-1.28 3.12-1.62 4.72-1.06l-2.89 2.89 2.82 2.82 2.86-2.87c.53 1.58.18 3.39-1.08 4.65zM3.81 16.21c.4.39 1.04.39 1.43 0 .4-.4.4-1.04 0-1.43-.39-.4-1.03-.4-1.43 0-.39.39-.39 1.03 0 1.43z" /></g></svg>;
	}

	if ( 'x' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><rect x="0" fill="none" width="20" height="20" /><g><path d="M14.95 6.46L11.41 10l3.54 3.54-1.41 1.41L10 11.42l-3.53 3.53-1.42-1.42L8.58 10 5.05 6.47l1.42-1.42L10 8.58l3.54-3.53z" /></g></svg>;
	}

	if ( 'reset' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" viewBox="0 0 50 50"><path d="M25 38c-5.1 0-9.7-3-11.8-7.6l1.8-.8c1.8 3.9 5.7 6.4 10 6.4 6.1 0 11-4.9 11-11s-4.9-11-11-11c-4.6 0-8.5 2.8-10.1 7.3l-1.9-.7c1.9-5.2 6.6-8.6 12-8.6 7.2 0 13 5.8 13 13s-5.8 13-13 13z" fill="currentColor" /><path d="M20 22h-8v-8h2v6h6z" fill="currentColor" /></svg>;
	}

	if ( 'dynamic' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" viewBox="0 0 921 921" fillRule="evenodd" clipRule="evenodd" strokeLinejoin="round" strokeMiterlimit="2"><path d="M869.447 50.856c67.809 67.817 67.809 750.774 0 818.59-67.817 67.807-750.774 67.807-818.591 0-67.808-67.816-67.808-750.773 0-818.59 67.817-67.808 750.774-67.808 818.591 0Zm-395.295 685.52h3.579c9.702 0 17.579 7.877 17.579 17.579v3.42H723.3c5.451-12.361 17.818-21 32.187-21 19.405 0 35.159 15.755 35.159 35.159 0 19.405-15.754 35.159-35.159 35.159-14.491 0-26.947-8.786-32.325-21.317H495.31v3.738c0 9.702-7.877 17.579-17.579 17.579h-35.159c-9.702 0-17.579-7.877-17.579-17.58v-3.737H197.141c-5.378 12.53-17.834 21.317-32.325 21.317-19.405 0-35.159-15.754-35.159-35.16 0-19.403 15.754-35.157 35.159-35.157 14.369 0 26.736 8.638 32.187 21h227.99v-3.421c0-9.702 7.877-17.58 17.579-17.58h3.58V609.535h28v126.842ZM129.657 414.193c0 29.527 148.09 53.5 330.495 53.5 182.404 0 330.494-23.973 330.494-53.5v94c0 29.527-148.09 53.5-330.494 53.5-182.405 0-330.495-23.973-330.495-53.5v-94Zm0-134.5c0 29.527 148.09 53.5 330.495 53.5 182.404 0 330.494-23.973 330.494-53.5v94c0 29.527-148.09 53.5-330.494 53.5-182.405 0-330.495-23.973-330.495-53.5v-94Zm.002-134.673c.591-29.45 148.453-53.327 330.493-53.327 182.404 0 330.494 23.973 330.494 53.5v94c0 29.527-148.09 53.5-330.494 53.5-182.405 0-330.495-23.973-330.495-53.5v-94l.002-.173Z" /></svg>;
	}

	if ( 'trash' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" fill="none" style={ { fill: 'none' } } stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" viewBox="0 0 24 24"><path d="M3 6h18M19 6v14a2 2 0 01-2 2H7a2 2 0 01-2-2V6m3 0V4a2 2 0 012-2h4a2 2 0 012 2v2M10 11v6M14 11v6" /></svg>;
	}

	if ( 'query-params' === icon ) {
		return <svg viewBox="0 0 2876 2876" xmlns="http://www.w3.org/2000/svg" fillRule="evenodd" clipRule="evenodd" strokeLinejoin="round" strokeMiterlimit="2"><path d="M2717.022 158.925c211.903 211.928 211.903 2346.168 0 2558.097-211.928 211.893-2346.169 211.893-2558.097 0-211.9-211.929-211.9-2346.17 0-2558.097 211.928-211.9 2346.169-211.9 2558.097 0ZM1786.4 1975.975c-155.978 116.55-349.419 185.565-558.85 185.565-515.969 0-934.872-418.9-934.872-934.872 0-515.968 418.903-934.868 934.872-934.868 515.969 0 934.872 418.9 934.872 934.868 0 211.963-70.694 407.541-189.725 564.372l508.869 508.87c25.609 25.608 25.609 67.196 0 92.805l-92.81 92.81c-25.61 25.61-67.197 25.61-92.806 0l-509.55-509.55ZM1227.55 529.253c384.916 0 697.419 312.5 697.419 697.415 0 384.916-312.503 697.42-697.419 697.42s-697.419-312.504-697.419-697.42c0-384.915 312.503-697.415 697.419-697.415Zm-28.434 1248.965c-43.153 0-77.044-11.55-101.666-34.65-24.625-23.1-36.934-54.703-36.934-94.812 0-40.616 12.309-72.472 36.934-95.572 24.622-23.1 58.513-34.65 101.666-34.65s76.915 11.55 101.284 34.65c24.369 23.1 36.553 54.956 36.553 95.572 0 40.11-12.184 71.712-36.553 94.812-24.369 23.1-58.131 34.65-101.284 34.65Zm-346.504-811.04c1.016-47.216 9.9-90.497 26.657-129.844 16.753-39.347 40.868-73.11 72.347-101.284 31.475-28.178 69.934-50.138 115.371-65.875 45.438-15.738 97.35-23.607 155.735-23.607 54.325 0 103.697 7.235 148.122 21.704 44.422 14.468 82.5 34.778 114.231 60.921 31.731 26.147 56.225 57.372 73.487 93.672 17.263 36.3 25.894 76.535 25.894 120.703 0 57.37-13.71 106.616-41.125 147.741-27.415 41.122-68.031 77.675-121.847 109.66-25.384 14.724-46.325 28.306-62.825 40.743-16.5 12.438-29.7 25.131-39.6 38.078-9.9 12.944-16.88 26.653-20.943 41.122-4.063 14.469-6.094 30.844-6.094 49.119v40.362h-201.806l-1.525-41.884c-2.538-30.462-1.775-57.878 2.284-82.247 4.063-24.369 11.678-46.581 22.847-66.634 11.169-20.053 26.019-38.46 44.55-55.213s40.997-32.747 67.397-47.978c24.369-14.722 44.803-28.303 61.303-40.74 16.503-12.438 29.703-25.004 39.603-37.697 9.9-12.694 16.878-26.02 20.94-39.982 4.063-13.962 6.094-29.828 6.094-47.596 0-17.77-3.428-34.016-10.28-48.738-6.854-14.722-16.629-27.416-29.32-38.078-12.693-10.66-27.925-19.038-45.693-25.131-17.77-6.09-37.57-9.138-59.4-9.138-44.17 0-79.582 12.438-106.235 37.316-26.656 24.878-41.25 58.384-43.79 100.525H852.612Z" /></svg>;
	}

	if ( 'caption' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" viewBox="0 0 32 32"><path fill="currentColor" d="M11.5 13C10.24 13 9 14.213 9 16s1.24 3 2.5 3a2.17 2.17 0 0 0 1.274-.421 1 1 0 1 1 1.164 1.626A4.17 4.17 0 0 1 11.5 21C8.893 21 7 18.632 7 16s1.893-5 4.5-5c.95 0 1.822.326 2.536.867a1 1 0 1 1-1.208 1.594A2.183 2.183 0 0 0 11.5 13Zm7.5 3c0-1.787 1.24-3 2.5-3 .479 0 .934.162 1.328.46a1 1 0 0 0 1.208-1.593A4.182 4.182 0 0 0 21.5 11c-2.607 0-4.5 2.368-4.5 5s1.893 5 4.5 5a4.17 4.17 0 0 0 2.438-.795 1 1 0 1 0-1.164-1.626A2.172 2.172 0 0 1 21.5 19c-1.26 0-2.5-1.213-2.5-3ZM2 8.5A4.5 4.5 0 0 1 6.5 4h19A4.5 4.5 0 0 1 30 8.5v15a4.5 4.5 0 0 1-4.5 4.5h-19A4.5 4.5 0 0 1 2 23.5v-15ZM6.5 6A2.5 2.5 0 0 0 4 8.5v15A2.5 2.5 0 0 0 6.5 26h19a2.5 2.5 0 0 0 2.5-2.5v-15A2.5 2.5 0 0 0 25.5 6h-19Z" /></svg>;
	}

	if ( 'add-pagination' === icon ) {
		return <svg fill="none" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M18 8.2h-5.2V3h-1.6v5.2H6v1.6h5.2V15h1.6V9.8H18V8.2ZM8.5 17.5h-3a1.5 1.5 0 0 0 0 3h3a1.5 1.5 0 0 0 0-3ZM15 19a1.5 1.5 0 1 0-3 0 1.5 1.5 0 0 0 3 0ZM20 19a1.5 1.5 0 1 0-3 0 1.5 1.5 0 0 0 3 0Z" fill="#000" /></svg>;
	}

	if ( 'section' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false"><path d="M17.646,3.5L17.646,5.52L15.568,5.52L15.568,6.335L17.607,6.335L17.607,8.374L18.422,8.374L18.422,6.361L20.5,6.361L20.5,20.5L3.5,20.5L3.5,3.5L17.646,3.5ZM20.5,5.546L18.462,5.546L18.462,3.5L20.5,3.5L20.5,5.546ZM6.192,8.374L6.192,6.335L8.23,6.335L8.23,5.52L5.784,5.52C5.559,5.52 5.376,5.703 5.376,5.928L5.376,8.374L6.192,8.374ZM10.065,5.52L10.065,6.335L13.734,6.335L13.734,5.52L10.065,5.52ZM17.607,10.208L17.607,13.877L18.422,13.877L18.422,10.208L17.607,10.208ZM18.014,18.566C18.239,18.566 18.422,18.383 18.422,18.158L18.422,15.712L17.607,15.712L17.607,17.75L15.568,17.75L15.568,18.566L18.014,18.566ZM8.23,18.566L8.23,17.75L6.192,17.75L6.192,15.712L5.376,15.712L5.376,18.158C5.376,18.382 5.56,18.566 5.784,18.566L8.23,18.566ZM5.376,10.208L5.376,13.877L6.192,13.877L6.192,10.208L5.376,10.208ZM10.065,17.75L10.065,18.566L13.734,18.566L13.734,17.75L10.065,17.75Z" /></svg>;
	}

	if ( 'add-to-container' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false"><path d="M20.641,4.436L20.641,7.202L19.562,7.202L19.562,4.504L16.864,4.504L16.864,3.424L19.593,3.424L19.593,0.658L20.672,0.658L20.672,3.357L23.371,3.357L23.371,4.436L20.641,4.436ZM20.102,20.695L16.864,20.695L16.864,19.615L19.562,19.615L19.562,16.917L20.641,16.917L20.641,20.155C20.641,20.453 20.4,20.695 20.102,20.695ZM9.578,19.615L14.435,19.615L14.435,20.695L9.578,20.695L9.578,19.615ZM7.149,20.695L3.911,20.695C3.615,20.695 3.371,20.451 3.371,20.155L3.371,16.917L4.45,16.917L4.45,19.615L7.149,19.615L7.149,20.695ZM3.371,9.63L4.45,9.63L4.45,14.488L3.371,14.488L3.371,9.63ZM4.45,7.202L3.371,7.202L3.371,3.964C3.371,3.666 3.613,3.424 3.911,3.424L7.149,3.424L7.149,4.504L4.45,4.504L4.45,7.202ZM9.578,3.424L14.435,3.424L14.435,4.504L9.578,4.504L9.578,3.424ZM19.562,9.63L20.641,9.63L20.641,14.488L19.562,14.488L19.562,9.63Z" /><path d="M18.366,6.051C18.366,5.857 18.209,5.7 18.014,5.7L5.998,5.7C5.804,5.7 5.646,5.857 5.646,6.051L5.646,18.068C5.646,18.262 5.804,18.419 5.998,18.419L18.014,18.419C18.209,18.419 18.366,18.262 18.366,18.068L18.366,6.051Z" /></svg>;
	}

	if ( 'add-to-row' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false"><path d="M20.642,4.435L20.642,7.2L19.563,7.2L19.563,4.502L16.866,4.502L16.866,3.423L19.594,3.423L19.594,0.658L20.673,0.658L20.673,3.356L23.371,3.356L23.371,4.435L20.642,4.435ZM20.103,20.688L16.866,20.688L16.866,19.609L19.563,19.609L19.563,16.912L20.642,16.912L20.642,20.149C20.642,20.447 20.401,20.688 20.103,20.688ZM9.582,19.609L14.438,19.609L14.438,20.688L9.582,20.688L9.582,19.609ZM7.154,20.688L3.917,20.688C3.621,20.688 3.377,20.445 3.377,20.149L3.377,16.912L4.456,16.912L4.456,19.609L7.154,19.609L7.154,20.688ZM3.377,9.628L4.456,9.628L4.456,14.483L3.377,14.483L3.377,9.628ZM4.456,7.2L3.377,7.2L3.377,3.963C3.377,3.665 3.619,3.423 3.917,3.423L7.154,3.423L7.154,4.502L4.456,4.502L4.456,7.2ZM9.582,3.423L14.438,3.423L14.438,4.502L9.582,4.502L9.582,3.423ZM19.563,9.628L20.642,9.628L20.642,14.483L19.563,14.483L19.563,9.628Z" /><path d="M11.284,5.898C11.284,5.819 11.22,5.755 11.142,5.755L5.777,5.755C5.699,5.755 5.635,5.819 5.635,5.898L5.635,18.214C5.635,18.293 5.699,18.356 5.777,18.356L11.142,18.356C11.22,18.356 11.284,18.293 11.284,18.214L11.284,5.898Z" /><path d="M18.384,5.922C18.384,5.83 18.31,5.755 18.217,5.755L12.903,5.755C12.811,5.755 12.736,5.83 12.736,5.922L12.736,18.189C12.736,18.282 12.811,18.356 12.903,18.356L18.217,18.356C18.31,18.356 18.384,18.282 18.384,18.189L18.384,5.922Z" /></svg>;
	}

	if ( 'add-to-stack' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false"><path d="M20.641,4.436L20.641,7.202L19.562,7.202L19.562,4.504L16.864,4.504L16.864,3.424L19.593,3.424L19.593,0.658L20.672,0.658L20.672,3.357L23.371,3.357L23.371,4.436L20.641,4.436ZM20.102,20.695L16.864,20.695L16.864,19.615L19.562,19.615L19.562,16.917L20.641,16.917L20.641,20.155C20.641,20.453 20.4,20.695 20.102,20.695ZM9.578,19.615L14.435,19.615L14.435,20.695L9.578,20.695L9.578,19.615ZM7.149,20.695L3.911,20.695C3.615,20.695 3.371,20.451 3.371,20.155L3.371,16.917L4.45,16.917L4.45,19.615L7.149,19.615L7.149,20.695ZM3.371,9.63L4.45,9.63L4.45,14.488L3.371,14.488L3.371,9.63ZM4.45,7.202L3.371,7.202L3.371,3.964C3.371,3.666 3.613,3.424 3.911,3.424L7.149,3.424L7.149,4.504L4.45,4.504L4.45,7.202ZM9.578,3.424L14.435,3.424L14.435,4.504L9.578,4.504L9.578,3.424ZM19.562,9.63L20.641,9.63L20.641,14.488L19.562,14.488L19.562,9.63Z" /><path d="M18.139,11.333C18.233,11.333 18.309,11.257 18.309,11.164L18.309,5.852C18.309,5.759 18.233,5.683 18.139,5.683L5.873,5.683C5.78,5.683 5.704,5.759 5.704,5.852L5.704,11.164C5.704,11.257 5.78,11.333 5.873,11.333L18.139,11.333Z" /><path d="M18.139,18.436C18.233,18.436 18.309,18.36 18.309,18.267L18.309,12.955C18.309,12.862 18.233,12.786 18.139,12.786L5.873,12.786C5.78,12.786 5.704,12.862 5.704,12.955L5.704,18.267C5.704,18.36 5.78,18.436 5.873,18.436L18.139,18.436Z" /></svg>;
	}

	if ( 'add-button' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false"><path d="M19.627,8.111L19.627,5.779L20.736,5.779L20.736,8.063L22.992,8.063L22.992,9.171L20.732,9.171L20.732,11.504L19.623,11.504L19.623,9.22L17.367,9.22L17.367,8.111L19.627,8.111Z" /><path d="M20.733,12.613L20.733,15.451C20.733,15.757 20.485,16.005 20.179,16.005L3.548,16.005C3.241,16.005 2.993,15.757 2.993,15.451L2.993,8.666C2.993,8.359 3.241,8.111 3.548,8.111L16.26,8.111L16.26,9.22L4.102,9.22L4.102,14.897L19.624,14.897L19.624,12.613L20.733,12.613Z" /><path d="M8.729,11.504L17.292,11.504C17.596,11.504 17.846,11.754 17.846,12.058C17.846,12.363 17.596,12.613 17.292,12.613L8.729,12.613C8.425,12.613 8.175,12.363 8.175,12.058C8.175,11.754 8.425,11.504 8.729,11.504Z" /><ellipse cx="6.6" cy="12.058" rx="0.716" ry="0.716" /></svg>;
	}

	if ( 'container-flex-column' === icon ) {
		return (
			<svg
				xmlns="http://www.w3.org/2000/svg"
				width="24"
				height="24"
				aria-hidden="true"
				viewBox="0 0 24 24"
			>
				<path d="M2 21.375v-3.75h1.25v3.125h3.125V22h-3.75A.625.625 0 012 21.375zM3.25 9.188v5.625H2V9.188h1.25zM2 6.375v-3.75C2 2.282 2.282 2 2.625 2h3.75v1.25H3.25v3.125H2zM17.625 3.25V2h3.75c.345 0 .625.28.625.625v3.75h-1.25V3.25h-3.125zM22 9.188v5.625h-1.25V9.188H22zM17.625 22v-1.25h3.125v-3.125H22v3.75c0 .345-.28.625-.625.625h-3.75z"></path>
				<path d="M19.299 11.159V4.616H4.701v6.543h14.598zM19.299 19.384v-6.543H4.701v6.543h14.598z"></path>
			</svg>
		);
	}

	if ( 'container-flex-row' === icon ) {
		return (
			<svg
				xmlns="http://www.w3.org/2000/svg"
				width="24"
				height="24"
				aria-hidden="true"
				viewBox="0 0 24 24"
			>
				<path d="M21.375 22h-3.75v-1.25h3.125v-3.125H22v3.75c0 .345-.28.625-.625.625zM9.188 20.75h5.625V22H9.188v-1.25zM6.375 22h-3.75A.628.628 0 012 21.375v-3.75h1.25v3.125h3.125V22zM3.25 6.375H2v-3.75C2 2.28 2.28 2 2.625 2h3.75v1.25H3.25v3.125zM9.188 2h5.625v1.25H9.188V2zM22 6.375h-1.25V3.25h-3.125V2h3.75c.345 0 .625.28.625.625v3.75z"></path>
				<path d="M4.616 4.701H11.16V19.298H4.616z"></path>
				<path d="M12.841 4.701H19.384999999999998V19.298H12.841z"></path>
			</svg>
		);
	}

	if ( 'container-default' === icon ) {
		return (
			<svg
				xmlns="http://www.w3.org/2000/svg"
				width="24"
				height="24"
				aria-hidden="true"
				viewBox="0 0 24 24"
			>
				<path d="M21.375 22h-3.75v-1.25h3.125v-3.125H22v3.75c0 .345-.28.625-.625.625zM9.188 20.75h5.625V22H9.188v-1.25zM6.375 22h-3.75A.628.628 0 012 21.375v-3.75h1.25v3.125h3.125V22zM2 9.187h1.25v5.625H2V9.187zm1.25-2.812H2v-3.75C2 2.28 2.28 2 2.625 2h3.75v1.25H3.25v3.125zM9.188 2h5.625v1.25H9.188V2zM22 6.375h-1.25V3.25h-3.125V2h3.75c.345 0 .625.28.625.625v3.75zm-1.25 2.812H22v5.625h-1.25V9.187z"></path>
				<path d="M4.635 4.635H19.365000000000002V19.365000000000002H4.635z"></path>
			</svg>
		);
	}

	if ( 'border-none' === icon ) {
		return (
			<svg
				aria-hidden="true"
				focusable="false"
				width="16"
				height="16"
				viewBox="0 0 16 16"
			>
				<path d="M9.414 8l3.293-3.293-1.414-1.414L8 6.586 4.707 3.293 3.293 4.707 6.586 8l-3.293 3.293 1.414 1.414L8 9.414l3.293 3.293 1.414-1.414L9.414 8z"></path>
			</svg>
		);
	}

	if ( 'border-solid' === icon ) {
		return (
			<svg
				aria-hidden="true"
				focusable="false"
				width="16"
				height="16"
				viewBox="0 0 16 16"
			>
				<path d="M1 7h14v2H1z"></path>
			</svg>
		);
	}

	if ( 'border-dashed' === icon ) {
		return (
			<svg
				aria-hidden="true"
				focusable="false"
				width="16"
				height="16"
				viewBox="0 0 16 16"
			>
				<path d="M0 7h4v2H0zm6 0h4v2H6zm6 0h4v2h-4z"></path>
			</svg>
		);
	}

	if ( 'border-dotted' === icon ) {
		return (
			<svg
				aria-hidden="true"
				focusable="false"
				width="16"
				height="16"
				viewBox="0 0 16 16"
			>
				<path d="M1 7h2v2H1zm4 0h2v2H5zm4 0h2v2H9zm4 0h2v2h-2z"></path>
			</svg>
		);
	}

	if ( 'border-default' === icon ) {
		return (
			<svg
				aria-hidden="true"
				focusable="false"
				width="16"
				height="16"
				viewBox="0 0 256 256"
				style={ { opacity: 0.1 } }
			>
				<rect width="256" height="256" fill="none" />
				<rect x="32" y="32" width="192" height="192" rx="16" />
			</svg>
		);
	}

	if ( 'borders' === icon ) {
		return (
			<svg width="20" height="20" viewBox="0 0 20 20" fillRule="evenodd" aria-hidden="true" focusable="false">
				<path d="M18.895,1.105C20.368,2.579 20.368,17.421 18.895,18.895C17.421,20.368 2.579,20.368 1.105,18.895C-0.368,17.421 -0.368,2.579 1.105,1.105C2.579,-0.368 17.421,-0.368 18.895,1.105ZM17.116,2.884C18.295,4.063 18.295,15.937 17.116,17.116C15.937,18.295 4.063,18.295 2.884,17.116C1.705,15.937 1.705,4.063 2.884,2.884C4.063,1.705 15.937,1.705 17.116,2.884Z" />
				<path d="M15.93,4.07C16.912,5.053 16.912,14.947 15.93,15.93C14.947,16.912 5.053,16.912 4.07,15.93C3.088,14.947 3.088,5.053 4.07,4.07C5.053,3.088 14.947,3.088 15.93,4.07Z" />
			</svg>
		);
	}

	if ( 'globe' === icon ) {
		return (
			<svg width="20" height="20" viewBox="0 0 256 256">
				<path fill="none" d="M0 0h256v256H0z" />
				<circle cx="128" cy="128" r="96" fill="none" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" strokeWidth="12" />
				<path d="M88 128c0 37.46 13.33 70.92 34.28 93.49a7.77 7.77 0 0 0 11.44 0C154.67 198.92 168 165.46 168 128s-13.33-70.92-34.28-93.49a7.77 7.77 0 0 0-11.44 0C101.33 57.08 88 90.54 88 128ZM32 128h192" fill="none" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" strokeWidth="12" />
			</svg>
		);
	}

	if ( 'info' === icon ) {
		return (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256" width="15" height="15">
				<rect width="256" height="256" fill="none" />
				<circle cx="128" cy="128" r="96" fill="none" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" strokeWidth="16" />
				<path d="M120,120a8,8,0,0,1,8,8v40a8,8,0,0,0,8,8" fill="none" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" strokeWidth="16" />
				<circle cx="124" cy="84" r="12" />
			</svg>
		);
	}

	if ( 'generateblocks' === icon ) {
		return <svg viewBox="0 0 50 60.12" xmlns="http://www.w3.org/2000/svg"><path d="M6.686 31.622V18.918a.077.077 0 0 1 .05-.072l6.5-2.313 6.5-2.313 9.682-3.445L39.1 7.33a.067.067 0 0 0 .036-.028.074.074 0 0 0 .014-.044V.076a.077.077 0 0 0-.032-.062.076.076 0 0 0-.069-.009l-13 4.625-13 4.625-6.5 2.313-6.5 2.313a.067.067 0 0 0-.036.028.097.097 0 0 0-.013.046V52.067c0 .026.013.048.032.062s.044.018.069.009l3.267-1.163 3.267-1.163c.015-.005.028-.015.036-.028s.014-.028.014-.044V37.999l.001-6.377c-.001 0 0 0 0 0z" /><path d="m23.949 29.976 13-4.625 13-4.625c.015-.005.028-.015.036-.028s.015-.028.015-.044V8.056a.077.077 0 0 0-.032-.062.076.076 0 0 0-.069-.009l-13 4.625-13 4.625-6.5 2.313-6.5 2.313a.067.067 0 0 0-.036.028.074.074 0 0 0-.014.044V60.045c0 .026.013.048.032.062a.076.076 0 0 0 .069.009l6.475-2.304 6.475-2.304 6.525-2.322 6.525-2.322 6.5-2.313 6.5-2.313c.015-.005.028-.015.036-.028s.014-.025.014-.041V27.193a.077.077 0 0 0-.032-.062.076.076 0 0 0-.069-.009l-6.45 2.295L37 31.711a.067.067 0 0 0-.036.028.074.074 0 0 0-.014.044v6.272a.077.077 0 0 1-.05.072l-6.45 2.295L24 42.715a.075.075 0 0 1-.101-.071V30.046c0-.016.005-.031.014-.044a.08.08 0 0 1 .036-.026z" /></svg>;
	}

	if ( 'database' === icon ) {
		return <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none" /><ellipse cx="128" cy="80" rx="88" ry="48" fill="none" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" strokeWidth="12" /><path d="M40,80v48c0,26.51,39.4,48,88,48s88-21.49,88-48V80" fill="none" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" strokeWidth="12" /><path d="M40,128v48c0,26.51,39.4,48,88,48s88-21.49,88-48V128" fill="none" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" strokeWidth="12" /></svg>;
	}

	if ( 'query' === icon ) {
		return <svg className="gb-block-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none" /><path d="M106.63,152.13l-8.69,9.81a48,48,0,1,1,0-67.88l60.12,67.88a48,48,0,1,0,0-67.88l-8.69,9.81" fill="none" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" strokeWidth="16" /></svg>;
	}

	if ( 'pagination' === icon ) {
		return (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" className="gblocks-block-icon" aria-hidden="true" focusable="false">
				<path d="M4.376,14.313L5.851,14.313L5.851,10.101L4.578,11.075L4,10.304L6.198,8.627L7.046,8.627L7.046,14.313L8.492,14.313L8.492,15.373L4.376,15.373L4.376,14.313Z" />
				<path d="M14.178,15.373L9.88,15.373L9.88,14.439C9.957,14.374 10.053,14.289 10.169,14.183C10.284,14.077 10.414,13.957 10.559,13.822C10.704,13.687 10.856,13.539 11.017,13.378C11.178,13.218 11.335,13.051 11.489,12.877C11.708,12.633 11.899,12.411 12.063,12.212C12.227,12.013 12.361,11.825 12.467,11.648C12.573,11.471 12.652,11.298 12.704,11.128C12.755,10.957 12.781,10.782 12.781,10.602C12.781,10.474 12.752,10.349 12.694,10.227C12.636,10.104 12.556,9.997 12.453,9.904C12.35,9.81 12.227,9.737 12.082,9.682C11.937,9.627 11.778,9.6 11.605,9.6C11.373,9.6 11.163,9.635 10.973,9.706C10.784,9.777 10.586,9.896 10.381,10.063L9.88,9.176C10.149,8.983 10.45,8.821 10.781,8.689C11.112,8.557 11.492,8.492 11.923,8.492C12.199,8.492 12.464,8.53 12.718,8.607C12.972,8.684 13.197,8.798 13.393,8.949C13.589,9.1 13.745,9.288 13.86,9.513C13.976,9.738 14.034,9.998 14.034,10.294C14.034,10.5 14.016,10.691 13.981,10.867C13.945,11.044 13.891,11.221 13.817,11.398C13.743,11.574 13.647,11.756 13.528,11.942C13.409,12.129 13.266,12.331 13.099,12.549C12.97,12.716 12.831,12.885 12.68,13.055C12.529,13.226 12.379,13.388 12.231,13.542C12.084,13.696 11.937,13.841 11.793,13.976C11.648,14.111 11.518,14.223 11.402,14.313L14.178,14.313L14.178,15.373Z" />
				<path d="M17.311,14.448C17.523,14.448 17.717,14.421 17.894,14.366C18.071,14.312 18.222,14.235 18.347,14.135C18.472,14.035 18.57,13.92 18.641,13.788C18.712,13.656 18.747,13.513 18.747,13.359C18.747,13.166 18.707,13.004 18.627,12.872C18.546,12.741 18.435,12.636 18.294,12.559C18.153,12.482 17.982,12.427 17.783,12.395C17.584,12.363 17.369,12.347 17.137,12.347L16.598,12.347L16.598,11.663L18.217,9.687L15.778,9.687L15.778,8.627L19.711,8.627L19.711,9.504L18.014,11.441L18.236,11.441C18.461,11.441 18.68,11.48 18.892,11.557C19.104,11.634 19.292,11.749 19.455,11.904C19.619,12.058 19.751,12.251 19.851,12.482C19.95,12.713 20,12.98 20,13.282C20,13.648 19.924,13.969 19.773,14.246C19.622,14.522 19.423,14.755 19.176,14.945C18.929,15.134 18.644,15.276 18.323,15.369C18.002,15.462 17.671,15.508 17.33,15.508C17.041,15.508 16.752,15.483 16.463,15.431C16.173,15.38 15.894,15.3 15.624,15.19L15.961,14.149C16.019,14.182 16.098,14.214 16.198,14.246C16.297,14.278 16.41,14.31 16.535,14.342C16.66,14.374 16.789,14.4 16.92,14.419C17.052,14.439 17.182,14.448 17.311,14.448Z" />
			</svg>
		);
	}

	if ( 'no-results' === icon ) {
		return (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" className="gblocks-block-icon" aria-hidden="true" focusable="false">
				<path d="M12,4C16.415,4 20,7.585 20,12C20,16.415 16.415,20 12,20C7.585,20 4,16.415 4,12C4,7.585 7.585,4 12,4ZM17.181,7.676L7.676,17.181C8.847,18.16 10.355,18.75 12,18.75C15.725,18.75 18.75,15.725 18.75,12C18.75,10.355 18.16,8.847 17.181,7.676ZM16.324,6.819C15.153,5.84 13.645,5.25 12,5.25C8.275,5.25 5.25,8.275 5.25,12C5.25,13.645 5.84,15.153 6.819,16.324L16.324,6.819Z" />
			</svg>
		);
	}
}
